document.addEventListener('click', function (e) {
  if (!e.ctrlKey) return;

  e.preventDefault();
  e.stopPropagation();

  let text = '';
  let el = document.elementFromPoint(e.clientX, e.clientY);

  if (el) {
    if (el.nodeType === Node.TEXT_NODE) {
      text = el.textContent;
    } else if (el instanceof HTMLElement) {
      text = el.innerText || el.textContent || '';
    }
  }

  if (!text) return;

  const regex = /[\w\-.]+/g;

  // Cross-browser caret position
  let range;
  if (document.caretRangeFromPoint) {
    range = document.caretRangeFromPoint(e.clientX, e.clientY);
  } else if (document.caretPositionFromPoint) {
    const pos = document.caretPositionFromPoint(e.clientX, e.clientY);
    if (pos) {
      range = document.createRange();
      range.setStart(pos.offsetNode, pos.offset);
      range.setEnd(pos.offsetNode, pos.offset);
    }
  }

  if (!range) return;

  const offset = range.startOffset;

  let match;
  let copiedWord = null;

  while ((match = regex.exec(text)) !== null) {
    if (offset >= match.index && offset <= match.index + match[0].length) {
      copiedWord = match[0];
      break;
    }
  }

  if (!copiedWord && text.trim().length > 0) {
    copiedWord = text.trim();
  }

  if (copiedWord) {
    navigator.clipboard.writeText(copiedWord).then(() => {
      showPopup(`Copied: ${copiedWord}`);
    }).catch(err => {
      console.error("Clipboard write failed:", err);
    });
  }
});

function showPopup(message) {
  const popup = document.createElement('div');
  popup.className = 'easy-copy-popup';
  popup.textContent = message;
  document.body.appendChild(popup);
  setTimeout(() => {
    popup.remove();
  }, 1500);
}
